#include <iostream>
#include <vector>
#include <cmath>
#include <algorithm>
#include <climits>
using namespace std;

struct vektor {
	long long x, y;
	int index;
	long double ugao;
};

long double ugao(long long x, long long y) {
	long double temp=atan2(y, x) * 180.0 / M_PI;
	if (temp<0) temp+=360.0;
	return temp;
}

bool sortiranje(vektor a, vektor b) {
	return a.ugao<b.ugao;
}

int main() {
	int n, r=0, best_l, best_r;
	long long max=-LLONG_MAX, max_x=0, max_y=0;
	scanf("%d", &n);
	std::vector<vektor> arr;

	for (int i=0; i<n; i++) {
		long long x, y;
		scanf("%lld %lld", &x, &y);
		arr.push_back({x,y,i,ugao(x, y)});
	}

	std::sort(arr.begin(), arr.end(), sortiranje);

	for (int i=0; i<n; i++) arr.push_back({arr[i].x,arr[i].y,arr[i].index,arr[i].ugao+360});

	for (int l=0; l<n; l++) {
		while (r<l+n && arr[r].ugao-arr[l].ugao<180) {
		    max_x+=arr[r].x;
		    max_y+=arr[r].y;
		    r++;
		}
		long long temp=max_x*max_x+max_y*max_y;
		if (temp>max) {
		    max=temp;
		    best_l=l;
		    best_r=r;
		}
	    max_x-=arr[l].x;
		max_y-=arr[l].y;
	}
	
	printf("%d\n", best_r-best_l);
	for (int i=best_l; i<best_r; i++) printf("%d ", arr[i].index+1);
	return 0;
}